<?php

/*
Plugin Name: Add_Posts_Column_Words
Plugin URI: http://pct.unifas.net/cms/wordpress/3282/
Description: 記事文字数を管理画面の記事一覧で表示します。ソート可能です。
Author: Kida Shintaro
Version: 0.5
Author URI: http://corp.unifas.net/
*/


function add_posts_column_words($columns) {
 $columns['post_words_num'] = '投稿文字数';
 return $columns;
}
add_filter( 'manage_posts_columns', 'add_posts_column_words' );
add_filter( 'manage_edit-post_sortable_columns', 'add_posts_column_words' );

function add_each_posts_column_words($column_name, $post_id) {
 if( 'post_words_num' == $column_name ) {
  $post_words_num = mb_strlen(strip_tags(get_post_field('post_content', $post_id)));
  echo $post_words_num;
  $post_words_num_old = get_post_meta($post_id,'投稿文字数',true);
  update_post_meta($post_id,'投稿文字数', $post_words_num, $post_words_num_old);
 }
}
add_action( 'manage_posts_custom_column', 'add_each_posts_column_words', 10, 2 );

function add_posts_column_orderby_words( $vars ) {
 if ( isset( $vars['orderby'] ) && '投稿文字数' == $vars['orderby'] ) {
  $vars = array_merge( $vars, array(
   'meta_key' => '投稿文字数', 
   'orderby' => 'meta_value_num',
  ));
 }
 return $vars;
}
add_filter( 'request', 'add_posts_column_orderby_words' );


